<?php
// /sorteio/api/state.php
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

$stateFile = __DIR__ . '/state.json';

if (!file_exists($stateFile)) {
  echo json_encode([
    "ok" => true,
    "state" => [
      "updated_at" => time(),
      "entries" => [],
      "countdown" => ["running" => false, "ends_at" => 0, "duration" => 0],
      "command" => ["id" => 0, "type" => "", "payload" => null],
      "winner" => null
    ]
  ]);
  exit;
}

$raw = file_get_contents($stateFile);
$data = json_decode($raw, true);

if (!$data) {
  echo json_encode(["ok" => false, "error" => "state_invalid_json"]);
  exit;
}

echo json_encode(["ok" => true, "state" => $data], JSON_UNESCAPED_UNICODE);
